<?php
use Modules\Sociallink\App\Services\SocialIcon;
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($socialProfile->username); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="text-white min-h-screen flex items-center justify-center"
    style="background: linear-gradient(<?php echo e($socialProfile->backgrounds['direction']); ?>deg, <?php echo e(implode(', ', $socialProfile->backgrounds['colors'])); ?>);">
    <div class="text-center max-w-xs w-full">
        <!-- Profile Picture -->
        <div class="w-24 h-24 mx-auto mb-4">
            <img src="<?php echo e($socialProfile->avatar); ?>" alt="Profile Picture"
                class="w-full h-full rounded-full object-cover">
        </div>
        <!-- Name -->
        <h1 class="text-lg font-semibold -m-1.5"> <?php echo e('@' . $socialProfile->username); ?></h1>
        <span class="text-xs text-gray-600">- <?php echo e($socialProfile?->category?->title); ?></span>
        <?php if($socialProfile->bio): ?>
        <p class="text-gray-300 font-medium italic text-xs sm:text-sm mt-0.5">
            <?php echo e($socialProfile->bio); ?>

        </p>
        <?php endif; ?>
        <!-- Icons -->
        <div class="flex justify-center gap-4 mt-2">

            <?php $__currentLoopData = $socialProfile->social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e($item->url); ?>" class="text-xl hover:text-gray-400">
                <img src="<?php echo e(SocialIcon::getIconUrl($item->icon)); ?>" alt="icon" class="w-5 h-5">
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </div>
        <!-- Links -->
        <div class="mt-6 space-y-3">

            <?php $__currentLoopData = $socialProfile->social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e($item->url); ?>" class="block bg-gray-800 text-center py-3 rounded-lg shadow hover:bg-gray-700">
                <?php echo e($item->name); ?>

            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <!-- Footer -->

        <?php if($socialProfile->phone_number && $socialProfile->email): ?>
        <div class="flex justify-center pb-1 pt-1  max-w-max mx-auto mt-3">
            <a href="<?php echo e(route('user.sociallink.profile.add-to-contacts', $socialProfile->uuid)); ?>"
                class="flex items-center gap-1 px-4 py-1 bg-gray-800  rounded-md transition-colors ">
                <img src="<?php echo e(SocialIcon::getIconUrl('bx-user-plus')); ?>" alt="icon" class="w-4 h-4">
                <span class="text-white text-xs">Add to contacts</span>
            </a>
        </div>
        <?php endif; ?>
        <div class="mt-6">
            <a href="#" class="text-sm font-semibold text-gray-400 hover:underline">
                ✱ Join <?php echo e($socialProfile->username); ?> on <?php echo e(config('app.name')); ?>

            </a>
        </div>
    </div>
</body>

</html><?php /**PATH /Volumes/my-works/laravel/stori-ai/modules/Sociallink/resources/views/v1.blade.php ENDPATH**/ ?>