<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\BrandLogo;
class BrandLogoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $brand_logos = array(
            array('id' => '1','category_id' => '94','preview' => '/uploads/image_66b8f591b04b5.png','canvas' => '{"version":"5.3.0","objects":[{"type":"image","version":"5.3.0","originX":"left","originY":"top","left":71,"top":199.8,"width":128,"height":128,"fill":"rgb(0,0,0)","stroke":null,"strokeWidth":0,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":0.68,"scaleY":0.68,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"cropX":0,"cropY":0,"src":"data:image/png;base64,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","crossOrigin":null,"filters":[]},{"type":"i-text","version":"5.3.0","originX":"left","originY":"top","left":176,"top":229.39,"width":133,"height":22.6,"fill":"white","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":1.96,"scaleY":1.96,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"fontFamily":"Arial","fontWeight":"bold","fontSize":20,"text":"Your text here","underline":false,"overline":false,"linethrough":false,"textAlign":"left","fontStyle":"normal","lineHeight":1.16,"textBackgroundColor":"","charSpacing":0,"styles":[],"direction":"ltr","path":null,"pathStartOffset":0,"pathSide":"left","pathAlign":"baseline","id":"slogan"}],"background":"transparent"}','status' => 'active','created_at' => '2024-08-11 17:32:01','updated_at' => '2024-08-11 17:32:01'),
            array('id' => '2','category_id' => '92','preview' => '/uploads/image_66b8f5e514b61.png','canvas' => '{"version":"5.3.0","objects":[{"type":"image","version":"5.3.0","originX":"left","originY":"top","left":154,"top":68,"width":256,"height":256,"fill":"rgb(0,0,0)","stroke":null,"strokeWidth":0,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":0.73,"scaleY":0.73,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"cropX":0,"cropY":0,"src":"data:image/png;base64,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","crossOrigin":null,"filters":[]},{"type":"i-text","version":"5.3.0","originX":"left","originY":"top","left":71,"top":259.62,"width":144.08,"height":22.6,"fill":"white","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":2.67,"scaleY":2.67,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"transparent","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"fontFamily":"Open Sans","fontWeight":"bold","fontSize":20,"text":"Your text here","underline":false,"overline":false,"linethrough":false,"textAlign":"center","fontStyle":"normal","lineHeight":1.16,"textBackgroundColor":"","charSpacing":0,"styles":[],"direction":"ltr","path":null,"pathStartOffset":0,"pathSide":"left","pathAlign":"baseline","id":"slogan"}],"background":"transparent"}','status' => 'active','created_at' => '2024-08-11 17:33:18','updated_at' => '2024-08-11 17:33:25'),
            array('id' => '3','category_id' => '93','preview' => '/uploads/image_66b8f679e0891.png','canvas' => '{"version":"5.3.0","objects":[{"type":"image","version":"5.3.0","originX":"left","originY":"top","left":143,"top":51,"width":256,"height":256,"fill":"rgb(0,0,0)","stroke":null,"strokeWidth":0,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":0.88,"scaleY":0.88,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"cropX":0,"cropY":0,"src":"data:image/png;base64,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","crossOrigin":null,"filters":[]},{"type":"i-text","version":"5.3.0","originX":"left","originY":"top","left":78,"top":290.31,"width":133,"height":22.6,"fill":"white","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeUniform":false,"strokeMiterLimit":4,"scaleX":2.55,"scaleY":2.55,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","skewX":0,"skewY":0,"fontFamily":"Arial","fontWeight":"bold","fontSize":20,"text":"Your text here","underline":false,"overline":false,"linethrough":false,"textAlign":"left","fontStyle":"normal","lineHeight":1.16,"textBackgroundColor":"","charSpacing":0,"styles":[],"direction":"ltr","path":null,"pathStartOffset":0,"pathSide":"left","pathAlign":"baseline","id":"slogan"}],"background":"transparent"}','status' => 'active','created_at' => '2024-08-11 17:35:53','updated_at' => '2024-08-11 17:35:53')
          );

          BrandLogo::insert($brand_logos);  
    }
}
